# Rovnou při načítání souboru vyrobíme seznam upravených řádek:
# 
# "1;Harry Potter and the Philosopher's Stone;2001;Chris Columbus"
#  =>
# "Philosopher's Stone;2001;Chris Columbus"
# ...
# "7b;Harry Potter and the Deathly Hallows – Part 2;2011;David Yates"
#  =>
# "Deathly Hallows – Part 2;2011;David Yates"
#
# ~ pro úpravu řetězců použijeme metody lstrip() a rstrip()
řádky = []
with open('filmy_1.csv', mode='tr', encoding='utf-8') as soubor:
    for řádka in soubor:
        # originální řádka (včetně '\n' na konci)
        print(řádka, end='')
        # zbavíme se '\n' na konci
        řádka = řádka.rstrip('\n')
        print('\t', řádka)
        # zbavíme se pořadového čísla na začátku včetně písmen a středníku
        řádka = řádka.lstrip('1234567890ab;')
        print('\t', řádka)
        # takto ořezanou řádku přidáme do nového seznamu
        řádky.append(řádka[21:])

print()
print(řádky)
print()

# vypíšeme prvky seznamu (upravené řádky) seřazené podle abecedy
for řádka in sorted(řádky):
    print(řádka)
